package gov.va.med.mhv.rxrefill.service;

import java.util.List;

import gov.va.med.mhv.common.api.exception.MHVException;
import gov.va.med.mhv.common.api.util.ResponseUtil;
import gov.va.med.mhv.rxrefill.data.model.PharmacyPatient;
import gov.va.med.mhv.rxrefill.data.model.Prescription;
import gov.va.med.mhv.rxrefill.data.model.Request;
import gov.va.med.mhv.rxrefill.dto.PrescriptionDTO;


/**
 * Application service interface for the Prescription service
 *
 */
public interface PrescriptionService {

	/**

	 * Execute the GetHistoricalPrescriptions operation
	 *
	 * @param pharmacyPatient
	 * @return PrescriptionCollectionServiceResponse
	 */
	public ResponseUtil getHistoricalPrescriptionsWithRequestStatuses(PharmacyPatient pharmacyPatient);

	/**
	 * Execute the GetActivePrescriptions operation
	 *
	 * @param pharmacyPatient
	 * @return PrescriptionCollectionServiceResponse
	 */
	public ResponseUtil getActivePrescriptions(PharmacyPatient pharmacyPatient);

	/**
	 * Execute the GetLastSuccessfulExtractRequestForUser operation
	 *
	 * @param pharmacyPatient
	 * @return RequestServiceResponse
	 */
	public List<Request> getLastSuccessfulExtractRequestForUser(PharmacyPatient pharmacyPatient);

	/**
	 * Execute the GetPharmacyPatient operation
	 *
	 * @param patient
	 * @return PharmacyPatientServiceResponse
	 */
	public PharmacyPatient getPharmacyPatient(Long userProfileId);

	/**
	 * Execute the GetPharmacyPatient operation
	 *
	 * @param pharmPatient
	 * @return
	 */
	public PharmacyPatient getPharmacyPatient(PharmacyPatient pharmPatient);
	
	/**
	 * Refill the list of prescriptions for the patient.
	 * @param pharmacyPatient The pharmacy patient.
	 * @param prescriptions The prescriptions being refilled.
	 * @return
	 */
	public ResponseUtil refillPrescriptions(PharmacyPatient pharmacyPatient, List<PrescriptionDTO> prescriptions, Boolean isAALRequired);

	/**

	 * Execute the GetAllPrescriptions operation
	 *
	 * @param pharmacyPatient
	 * @return PrescriptionCollectionServiceResponse
	 */
	public ResponseUtil getAllPrescriptions(PharmacyPatient pharmacyPatient);

	/**
	 * Creates a pharmacy patient.
	 * @param userProfileId The user profile identifier.
	 * @return The new pharmacy patient.
	 */
	PharmacyPatient createPharmacyPatient(Long userProfileId);

	/**
	 * Deletes a locally stored prescription.
	 * @param userId The user whose prescription is being deleted.
	 * @param institutionId The ID of the institution where the prescription was issued.
	 */
	void deletePrescriptionsForUserInstitutions(Long userId, Long institutionId);
	/**
	 * Execute the getRequestByFunctionAndInstitution operation
	 *
	 * @param userProfileId The user profile identifier.
	 * @param institutionId.
	 * @return
	 */
	public List<Request> getRequestByFunctionAndInstitution(Long userId, Long institutionId);
	
	
	public void refreshHistoricalPrescriptions(PharmacyPatient pharmacyPatient, ResponseUtil response);
	
	
	public List<Prescription>  getTrackingPrescriptionsForEmails(Long userprofileId) throws MHVException;
	
}